--
-- handbrake
--
-- handbremse
--
-- @author ???
--
-- @complement by Amarlich (16.01.2013)
--

handBrake = {};

function handBrake.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function handBrake:load(xmlFile)
	self.setHandBrakeState = SpecializationUtil.callSpecializationsFunction("setHandBrakeState");
	self.handBrakeHud = Overlay:new("hBOverlay", Utils.getFilename("texture/hb_symbol.dds", self.baseDirectory), 0.785, 0.250, 0.040, 0.050);
	
	self.handbrake = true;
    
	handbrakeSoundFile = Utils.getFilename("sound/handbrake_up.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	handbrakeReleaseSoundFile = Utils.getFilename("sound/handbrake_down.wav", self.baseDirectory);
    self.handbrakeReleaseSoundId = createSample("handbrakeReleaseSound");
    loadSample(self.handbrakeReleaseSoundId, handbrakeReleaseSoundFile, false);
    self.handbrakeReleasePlaying = false;

	brakeSoundFile = Utils.getFilename("sound/empty.wav", self.baseDirectory);
    self.brakeSoundId = createSample("brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("sound/empty.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    
	self.brakereleasePlaying = false;
    self.BreakForceVal = 10000/self.motor.brakeForce;

    self.HandBrakeTurnOff = false;
end;

function handBrake:delete()

end;

function handBrake:mouseEvent(posX, posY, isDown, isUp, button)

end;

function handBrake:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_9 then
		self:setHandBrakeState(not self.handbrake);
		if self.handbrake and self:getIsActiveForSound() then
			playSample(self.handbrakeSoundId,1,1,0);
		end;
	end;
    if not isDown and sym == Input.KEY_9 then
		self:setHandBrakeState(self.handbrake);
		if not self.handbrake and self:getIsActiveForSound() then
			playSample(self.handbrakeReleaseSoundId,1,1,0);
		end;
	end;
end;

function setHandBrakeState(state, noEventSend)
HandbrakeEvent.sendEvent(self, state, noEventSend); -- MP Fix by modelleicher, addet Event
    self.handbrake = state;
    self.HandBrakeTurnOff = state;
    setVisibility(self.handbrakelight, state);
end;

function handBrake:updateTick(dt)
   if self.isServer then
        if self.handbrake then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 9, 0);
                end;
            end;
        elseif not self.handbrake and self.HandBrakeTurnOff then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, 0);
                end;
            end;
            self.HandBrakeTurnOff = false;
        end;
    end;
end;

function handBrake:update(dt)

	if self.isMotorStarted then        
		if Input.isKeyPressed(Input.KEY_s) then
				if not self.braking then
					self.braking = true;
				end;
				if not self.brakePlaying and self:getIsActiveForSound() then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;				
		else
			self.brakePlaying = false;
			self.braking = false;
			if not self.brakereleasePlaying and self:getIsActiveForSound() then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;
	end;
end;

function handBrake:draw()
	if self.isEntered then	
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_w) then
				self.handBrakeHud:render();
			end;
		self.handBrakeHud:render();
		end;
		end;
		if self.handbrake == false then
		g_currentMission:addHelpButtonText(g_i18n:getText("handbrakeON"), InputBinding.handbrake);
		else
		g_currentMission:addHelpButtonText(g_i18n:getText("handbrakeOFF"), InputBinding.handbrake);
	end;
	if self.isEntered then	
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_w) then
				g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
			end;
		end;
	end;
	if self.isEntered then	
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_s) then
				g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
			end;
		end;
	end;
end;

function handBrake:onLeave()

end;

function handBrake:setHandBrakeState(state, noEventSend)
    self.handbrake = state;
    self.HandBrakeTurnOff = state;
end;

-- HANDBRAKE EVENT --
-- MP Fix by modelleicher
HandbrakeEvent = {};
HandbrakeEvent_mt = Class(HandbrakeEvent, Event);

InitEventClass(HandbrakeEvent, "HandbrakeEvent");

function HandbrakeEvent:emptyNew()
    local self = Event:new(HandbrakeEvent_mt);
    self.className = "HandbrakeEvent";
    return self;
end;

function HandbrakeEvent:new(object, state)
    local self = HandbrakeEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function HandbrakeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function HandbrakeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function HandbrakeEvent:run(connection)
    self.object:setHandBrakeState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(HandbrakeEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function HandbrakeEvent.sendEvent(vehicle, state, noEventSend)
    if state ~= vehicle.handbrake then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(HandbrakeEvent:new(vehicle, state), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(HandbrakeEvent:new(vehicle, state));
            end;
        end;
    end;
end;